; Tetrimino.s : eg~m
;


; W[錾
;
    .module Tetrimino

; Qƃt@C
;
    .include    "bios.inc"
    .include    "vdp.inc"
    .include    "System.inc"
    .include    "App.inc"
    .include    "Game.inc"
    .include    "Matrix.inc"
    .include	"Tetrimino.inc"

; Oϐ錾
;

; }N̒`
;


; CODE ̈
;
    .area   _CODE

; eg~m
;
_TetriminoInitialize::
    
    ; WX^̕ۑ
    
    ; eg~m̏
    ld      hl, #tetriminoDefault
    ld      de, #_tetrimino
    ld      bc, #TETRIMINO_SIZE
    ldir
    
    ; L[̏
    ld      hl, #(tetriminoQueue + 0x0000)
    ld      de, #(tetriminoQueue + 0x0001)
    ld      bc, #((TETRIMINO_TYPE_SIZE - 1) * 2)
    xor     a
    ld      (hl), a
    ldir
    
    ; ̃eg~m̏
    ld      hl, #(APP_COLOR_TABLE_0 + 0x0300)
    ld      a, #0x00
    ld      bc, #0x0080
    call    FILVRM
    ld      hl, #(APP_COLOR_TABLE_1 + 0x0300)
    ld      a, #0x00
    ld      bc, #0x0100
    call    FILVRM
    ld      hl, #(APP_COLOR_TABLE_2 + 0x0300)
    ld      a, #0x00
    ld      bc, #0x0080
    call    FILVRM
    
    ; WX^̕A
    
    ; I
    ret

; eg~mXV
;
_TetriminoUpdate::
    
    ; WX^̕ۑ
    
    ; WX^̕A
    
    ; I
    ret

; eg~m`悷
;
_TetriminoRender::

    ; WX^̕ۑ
    
    ; XvCg̕`
    ld      ix, #_tetrimino
    ld      a, TETRIMINO_TYPE(ix)
    or      a
    jr      z, 9$
    ld      a, TETRIMINO_TIMER(ix)
    and     #0x01
    add     a, a
    add     a, a
    add     a, a
    add     a, a
    add     a, a
    ld      e, a
    ld      d, #0x00
    ld      iy, #(_sprite + GAME_SPRITE_TETRIMINO_NORMAL)
    add     iy, de
    call    TetriminoDrawSprite
    ld      a, TETRIMINO_POSITION_Y(ix)
    ld      ix, #_tetriminoGhost
    cp      TETRIMINO_POSITION_Y(ix)
    jr      z, 9$
    ld      iy, #(_sprite + GAME_SPRITE_TETRIMINO_GHOST)
    ld      a, #TETRIMINO_PATTERN_GHOST
    ld      TETRIMINO_PATTERN(ix), a
    call    TetriminoDrawSprite
9$:
    
    ; WX^̕A
    
    ; I
    ret

; eg~mZbg
;
_TetriminoReset::

    ; WX^̕ۑ
    
    ; L[̐ݒ
    ld      hl, #tetriminoQueue
    call    TetriminoMakeQueue
    ld      hl, #(tetriminoQueue + (TETRIMINO_TYPE_SIZE - 1))
    call    TetriminoMakeQueue
    ld      hl, #(tetriminoQueue + (TETRIMINO_TYPE_SIZE - 1) * 2)
    xor     a
    ld      (hl), a
    
    ; ̃eg~m̐ݒ
    ld      hl, #tetriminoNextColor
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_0_SRC), hl
    ld      hl, #(APP_COLOR_TABLE_0 + 0x0300)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_0_DST), hl
    ld      a, #0x80
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_0_BYTES), a
    ld      hl, #tetriminoNextColor
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_1_SRC), hl
    ld      hl, #(APP_COLOR_TABLE_1 + 0x0300)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_1_DST), hl
    ld      a, #0x80
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_1_BYTES), a
    ld      hl, #tetriminoNextColor
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_2_SRC), hl
    ld      hl, #(APP_COLOR_TABLE_1 + 0x0380)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_2_DST), hl
    ld      a, #0x80
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_2_BYTES), a
    ld      hl, #tetriminoNextColor
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_3_SRC), hl
    ld      hl, #(APP_COLOR_TABLE_2 + 0x0300)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_3_DST), hl
    ld      a, #0x80
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_3_BYTES), a
    ld      hl, #(_request)
    set     #REQUEST_VRAM, (hl)
    
    ; WX^̕A
    
    ; I
    ret

; eg~m𐶐
;
_TetriminoGenerate::

    ; WX^̕ۑ
    
    ; eg~m̐
    ld      a, (tetriminoQueue)
    ld      d, #0x00
    add     a, a
;   rl      d
    add     a, a
;   rl      d
    add     a, a
;   rl      d
    add     a, a
;   rl      d
    ld      e, a
    ld      hl, #tetriminoDefault
    add     hl, de
    ld      de, #_tetrimino
    ld      bc, #TETRIMINO_SIZE
    ldir
    
    ; S[Xg̐
    ld      hl, #_tetrimino
    ld      de, #_tetriminoGhost
    ld      bc, #TETRIMINO_SIZE
    ldir
    
    ; x̐ݒ
    ld      a, (_gameLevel)
    ld      e, a
    ld      d, #0x00
    ld      hl, #tetriminoFallInterval
    add     hl, de
    ld      (_tetrimino + TETRIMINO_FALL), a
    
    ; L[̍XV
    ld      hl, #(tetriminoQueue + 0x0001)
    ld      de, #(tetriminoQueue + 0x0000)
    ld      bc, #((TETRIMINO_TYPE_SIZE - 1) * 2)
    ldir
    ld      hl, #(tetriminoQueue + (TETRIMINO_TYPE_SIZE - 1))
    ld      a, (hl)
    or      a
    call    z, TetriminoMakeQueue
    
    ; ̃eg~m̐ݒ
    ld      ix, #tetriminoQueue
    ld      d, 0x00(ix)
    ld      e, #0x00
    srl     d
    rr      e
    ld      hl, #tetriminoNextColor
    add     hl, de
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_0_SRC), hl
    ld      hl, #(APP_COLOR_TABLE_0 + 0x0300)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_0_DST), hl
    ld      a, #0x80
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_0_BYTES), a
    ld      d, 0x01(ix)
    ld      e, #0x00
    srl     d
    rr      e
    ld      hl, #tetriminoNextColor
    add     hl, de
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_1_SRC), hl
    ld      hl, #(APP_COLOR_TABLE_1 + 0x0300)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_1_DST), hl
    ld      a, #0x80
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_1_BYTES), a
    ld      d, 0x02(ix)
    ld      e, #0x00
    srl     d
    rr      e
    ld      hl, #tetriminoNextColor
    add     hl, de
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_2_SRC), hl
    ld      hl, #(APP_COLOR_TABLE_1 + 0x0380)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_2_DST), hl
    ld      a, #0x80
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_2_BYTES), a
    ld      d, 0x03(ix)
    ld      e, #0x00
    srl     d
    rr      e
    ld      hl, #tetriminoNextColor
    add     hl, de
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_3_SRC), hl
    ld      hl, #(APP_COLOR_TABLE_2 + 0x0300)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_3_DST), hl
    ld      a, #0x80
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_3_BYTES), a
    ld      hl, #(_request)
    set     #REQUEST_VRAM, (hl)
    
    ; eg~m̑
    ld      ix, #_tetrimino
    call    TetriminoIsPut
    jr      z, 99$
    push    af
    call    TetriminoPut
    ld      hl, #_tetrimino
    ld      de, #_tetriminoGhost
    ld      bc, #TETRIMINO_SIZE
    ldir
    pop     af
    
    ; ̊
99$:
    
    ; WX^̕A
    
    ; I
    ret

; P̃L[쐬  
;
TetriminoMakeQueue:
    
    ; WX^̕ۑ
    
    ; ЂƂ낦̃eg~m
    push    hl
    ld      a, #(TETRIMINO_TYPE_NULL + 1)
    ld      b, #(TETRIMINO_TYPE_SIZE - 1)
10$:
    ld      (hl), a
    inc     hl
    inc     a
    djnz    10$
    pop     hl
    
    ; Vbt
    ld      bc, #(((TETRIMINO_TYPE_SIZE - 1) << 8) + 0x00)
20$:
    push    bc
    push    hl
    call    _SystemGetRandom
    and     #0x0f
    cp      #(TETRIMINO_TYPE_SIZE - 1)
    jr      c, 21$
    sub     #(TETRIMINO_TYPE_SIZE - 1)
21$:
    push    bc
    ld      e, l
    ld      d, h
    ld      c, a
    ld      b, #0x00
    add     hl, bc
    ex      de, hl
    pop     bc
    ld      b, #0x00
    add     hl, bc
    ld      a, (hl)
    ld      c, a
    ld      a, (de)
    ld      (hl), a
    ld      a, c
    ld      (de), a
    pop     hl
    pop     bc
    inc     c
    djnz    20$
    
    ; WX^̕A
    
    ; I
    ret

; eg~m
;
_TetriminoFall::

    ; WX^̕ۑ
    
    ; eg~m̎擾
    ld      ix, #_tetrimino
    
    ; Õeg~m̕ۑ
    ld      hl, #_tetrimino
    ld      de, #tetriminoLast
    ld      bc, #TETRIMINO_SIZE
    ldir
    
    ; ^C}̍XV
    inc     TETRIMINO_TIMER(ix)
    
    ; 
    ld      c, #0x00
    ld      a, (_input + INPUT_KEY_LEFT)
    or      a
    jr      z, 12$
    dec     a
    jr      z, 10$
    dec     TETRIMINO_INPUT_LEFT(ix)
    jr      nz, 19$
    ld      a, #TETRIMINO_INPUT_INTERVAL_1
    jr      11$
10$:
    ld      a, #TETRIMINO_INPUT_INTERVAL_0
11$:
    ld      TETRIMINO_INPUT_LEFT(ix), a
    ld      c, #0x10
    jr      19$
12$:
    ld      a, (_input + INPUT_KEY_RIGHT)
    or      a
    jr      z, 19$
    dec     a
    jr      z, 13$
    dec     TETRIMINO_INPUT_RIGHT(ix)
    jr      nz, 19$
    ld      a, #TETRIMINO_INPUT_INTERVAL_1
    jr      14$
13$:
    ld      a, #TETRIMINO_INPUT_INTERVAL_0
14$:
    ld      TETRIMINO_INPUT_RIGHT(ix), a
    ld      c, #0x20
19$:
    ld      a, TETRIMINO_POSITION_X(ix)
    and     #0x01
    add     a, a
    add     a, a
    add     a, a
    add     a, c
    ld      TETRIMINO_DETECT_MOVE(ix), a

    ; ]̍Eړ
    ld      c, TETRIMINO_ROTATE(ix)
    ld      TETRIMINO_DETECT_ROTATE(ix), c
    ld      a, (_input + INPUT_BUTTON_SPACE)
    dec     a
    jr      nz, 20$
    ld      a, c
    inc     a
    cp      #TETRIMINO_ROTATE_SIZE
    jr      c, 21$
    xor     a
    jr      21$
20$:
    ld      a, (_input + INPUT_BUTTON_SHIFT)
    dec     a
    jr      nz, 29$
    ld      a, c
    dec     a
    cp      #TETRIMINO_ROTATE_SIZE
    jr      c, 21$
    ld      a, #(TETRIMINO_ROTATE_SIZE - 1)
21$:
    ld      TETRIMINO_ROTATE(ix), a
    call    TetriminoDetect
    ld      e, TETRIMINO_DETECT_MOVE(ix)
    ld      d, #0x00
    ld      hl, #tetriminoDetectRotate
    add     hl, de
    ld      c, TETRIMINO_DETECT(ix)
    ld      b, #TETRIMINO_DETECT_SIZE
22$:
    ld      a, (hl)
    and     c
    jr      nz, 39$
    inc     hl
    djnz    22$
    ld      a, TETRIMINO_TYPE(ix)
    cp      #TETRIMINO_TYPE_I
    jr      z, 23$
    cp      #TETRIMINO_TYPE_L
    jr      z, 23$
    cp      #TETRIMINO_TYPE_J
    jr      nz, 29$
23$:
    ld      a, TETRIMINO_ROTATE(ix)
    cp      #TETRIMINO_ROTATE_000
    jr      z, 29$
    cp      #TETRIMINO_ROTATE_180
    jr      z, 29$
    ld      a, TETRIMINO_POSITION_X(ix)
    ld      d, a
    cp      #0x04
    jr      c, 24$
    sub     #0x02
    ld      TETRIMINO_POSITION_X(ix), a
    push    de
    call    TetriminoIsPut
    pop     de
    ld      TETRIMINO_POSITION_X(ix), d
    jr      nz, 24$
    ld      a, #TETRIMINO_DETECT_270
    jr      39$
24$:
    cp      #0x0b
    jr      nc, 29$
    add     #0x02
    ld      TETRIMINO_POSITION_X(ix), a
    push    de
    call    TetriminoIsPut
    pop     de
    ld      TETRIMINO_POSITION_X(ix), d
    jr      nz, 29$
    ld      a, #TETRIMINO_DETECT_090
    jr      39$
29$:
    
    ; ]Ȃ̍Eړ
    ld      a, TETRIMINO_DETECT_ROTATE(ix)
    ld      TETRIMINO_ROTATE(ix), a
    call    TetriminoDetect
    ld      e, TETRIMINO_DETECT_MOVE(ix)
    ld      d, #0x00
    ld      hl, #tetriminoDetectMove
    add     hl, de
    ld      c, TETRIMINO_DETECT(ix)
    ld      b, #TETRIMINO_DETECT_SIZE
30$:
    ld      a, (hl)
    and     c
    jr      nz, 39$
    inc     hl
    djnz    30$
    jr      49$
39$:
    
    ; Ëړ̊m
    ld      c, a
    ld      a, TETRIMINO_POSITION_X(ix)
    and     #0x01
    add     a, a
    add     a, a
    add     a, a
    add     a, a
    ld      e, a
    ld      d, #0x00
    ld      hl, #(tetriminoDetectPoint - 0x0002)
    add     hl, de
    ld      e, #0x02
40$:
    add     hl, de
    srl     c
    jr      nc, 40$
    ld      a, (hl)
    ld      b, a
    add     a, TETRIMINO_POSITION_X(ix)
    ld      TETRIMINO_POSITION_X(ix), a
    inc     hl
    ld      a, (hl)
    ld      c, a
    add     a, TETRIMINO_POSITION_Y(ix)
    ld      TETRIMINO_POSITION_Y(ix), a
    
    ; ]ړ
    ld      a, b
    or      c
    jr      nz, 41$
    ld      a, TETRIMINO_ROTATE(ix)
    cp      TETRIMINO_DETECT_ROTATE(ix)
    jr      z, 49$
41$:
    ld      a, #TETRIMINO_LOCK_INTERVAL
    ld      TETRIMINO_LOCK(ix), a
    
    ; Ëړ̊
49$:
    
    ; S[Xg̎擾
    ld      hl, #_tetrimino
    ld      de, #_tetriminoGhost
    ld      bc, #TETRIMINO_SIZE
    ldir
    ld      ix, #_tetriminoGhost
50$:
    inc     TETRIMINO_POSITION_Y(ix)
    call    TetriminoIsPut
    jr      z, 50$
    dec     TETRIMINO_POSITION_Y(ix)
    
    ; eg~m̍Ď擾
    ld      ix, #_tetrimino
    ld      iy, #_tetriminoGhost
    ld      c, #0x00
    
    ; n[hhbv
    ld      a, (_input + INPUT_KEY_UP)
    dec     a
    jr      nz, 60$
    ld      a, TETRIMINO_POSITION_Y(iy)
    sub     TETRIMINO_POSITION_Y(ix)
    add     a, a
    ld      c, a
    ld      a, TETRIMINO_POSITION_Y(iy)
    ld      TETRIMINO_POSITION_Y(ix), a
    jr      90$
60$:
    
    ; bN_E
    ld      a, TETRIMINO_POSITION_Y(iy)
    cp      TETRIMINO_POSITION_Y(ix)
    jr      nz, 61$
    dec     TETRIMINO_LOCK(ix)
    jr      z, 90$
;   jr      99$
    jp      99$
61$:
    
    ; \tghbv
    ld      a, (_input + INPUT_KEY_DOWN)
    or      a
    jr      z, 62$
    dec     a
    jr      z, 63$
    dec     TETRIMINO_INPUT_DROP(ix)
    jr      nz, 62$
    ld      a, #TETRIMINO_INPUT_INTERVAL_1
    inc     c
    jr      64$
62$:
    dec     TETRIMINO_FALL(ix)
    jr      nz, 99$
    ld      a, #TETRIMINO_INPUT_INTERVAL_0
    jr      64$
63$:
    ld      a, #TETRIMINO_INPUT_INTERVAL_0
    inc     c
64$:
    ld      TETRIMINO_INPUT_DROP(ix), a
    ld      a, (_gameLevel)
    ld      e, a
    ld      d, #0x00
    ld      hl, #tetriminoFallLine
    add     hl, de
    ld      a, TETRIMINO_POSITION_Y(iy)
    sub     TETRIMINO_POSITION_Y(ix)
    cp      (hl)
    jr      c, 65$
    ld      a, (hl)
65$:
    ld      b, a
    add     a, TETRIMINO_POSITION_Y(ix)
    ld      TETRIMINO_POSITION_Y(ix), a
    ld      a, c
    or      a
    jr      z, 66$
    ld      c, b
66$:
    ld      a, (_gameLevel)
;;  ld      e, a
;;  ld      d, #0x00
    ld      hl, #tetriminoFallInterval
    add     hl, de
    ld      a, (hl)
    ld      TETRIMINO_FALL(ix), a
    jr      99$
    
    ; eg~m̃bN
90$:
    push    bc
    call    TetriminoIsPut
    jr      nz, 91$
    call    TetriminoPut
    xor     a
    ld      TETRIMINO_TYPE(ix), a
    jr      93$
    
    ; CM[ȏԂւ̑Ή
91$:
    ld      hl, #tetriminoLast
    ld      de, #_tetrimino
    ld      bc, #TETRIMINO_SIZE
    ldir
    ld      hl, #_tetrimino
    ld      de, #_tetriminoGhost
    ld      bc, #TETRIMINO_SIZE
    ldir
    ld      ix, #_tetriminoGhost
92$:
    inc     TETRIMINO_POSITION_Y(ix)
    call    TetriminoIsPut
    jr      z, 92$
    dec     TETRIMINO_POSITION_Y(ix)
93$:
    pop     bc
    
    ; ̊
99$:
    ld      a, c
    
    ; WX^̕A
    
    ; I
    ret

; eg~m̎͂ňړ\Ȉʒu𔻒肷
;
TetriminoDetect:

    ; WX^̕ۑ
    
    ; ͂̈ʒu̎擾
    ld      a, TETRIMINO_POSITION_X(ix)
    and     #0x01
    add     a, a
    add     a, a
    add     a, a
    add     a, a
    ld      e, a
    ld      d, #0x00
    ld      hl, #tetriminoDetectPoint
    add     hl, de
    
    ; ݂̈ʒu̎擾
    ld      e, TETRIMINO_POSITION_X(ix)
    ld      d, TETRIMINO_POSITION_Y(ix)
    
    ; ړ\ǂ̔
    ld      bc, #((TETRIMINO_DETECT_SIZE << 8) | 0x00)
0$:
    srl     c
    ld      a, (hl)
    add     a, e
    ld      TETRIMINO_POSITION_X(ix), a
    inc     hl
    ld      a, (hl)
    add     a, d
    ld      TETRIMINO_POSITION_Y(ix), a
    inc     hl
    push    bc
    push    de
    push    hl
    call    TetriminoIsPut
    pop     hl
    pop     de
    pop     bc
    jr      nz, 1$
    ld      a, #0b00100000
    or      c
    ld      c, a
1$:
    djnz    0$
    ld      TETRIMINO_DETECT(ix), c
    
    ; ʒu̕A
    ld      TETRIMINO_POSITION_X(ix), e
    ld      TETRIMINO_POSITION_Y(ix), d
    
    ; WX^̕A
    
    ; I
    ret

; eg~m}gNXu邩ǂ
;
TetriminoIsPut:
    
    ; WX^̕ۑ
    
    ; eg~m̔
    ld      a, TETRIMINO_POSITION_X(ix)
    and     #0x01
    ld      e, a
    ld      a, TETRIMINO_ROTATE(ix)
    add     a, a
    add     a, e
    add     a, a
    add     a, a
    add     a, a
    ld      e, a
    ld      d, TETRIMINO_TYPE(ix)
    xor     a
    srl     d
    rra
    add     a, e
    ld      e, a
    ld      iy, #tetriminoLocation
    add     iy, de
    ld      a, TETRIMINO_POSITION_Y(ix)
    ld      d, #0x00
    add     a, a
    rl      d
    add     a, a
    rl      d
    add     a, a
    rl      d
    add     a, a
    rl      d
    add     a, TETRIMINO_POSITION_X(ix)
    ld      e, a
    ld      hl, #_matrix
    add     hl, de
    ld      b, #0x04
0$:
    ld      e, 0x00(iy)
    ld      d, 0x01(iy)
    add     hl, de
    ld      a, (hl)
    or      a
    jr      nz, 9$
    inc     iy
    inc     iy
    djnz    0$
    
    ; ̊
9$:
    
    ; WX^̕A
    
    ; I
    ret

; eg~m}gNXɒu
;
TetriminoPut:
    
    ; WX^̕ۑ
    
    ; eg~mu
    ld      a, TETRIMINO_POSITION_X(ix)
    and     #0x01
    ld      e, a
    ld      a, TETRIMINO_ROTATE(ix)
    add     a, a
    add     a, e
    add     a, a
    add     a, a
    add     a, a
    ld      e, a
    ld      d, TETRIMINO_TYPE(ix)
    xor     a
    srl     d
    rra
    add     a, e
    ld      e, a
    ld      iy, #tetriminoLocation
    add     iy, de
    ld      a, TETRIMINO_POSITION_Y(ix)
    ld      d, #0x00
    add     a, a
    rl      d
    add     a, a
    rl      d
    add     a, a
    rl      d
    add     a, a
    rl      d
    add     a, TETRIMINO_POSITION_X(ix)
    ld      e, a
    ld      hl, #_matrix
    add     hl, de
    ld      b, #0x04
0$:
    ld      e, 0x00(iy)
    ld      d, 0x01(iy)
    add     hl, de
    ld      a, TETRIMINO_COLOR(ix)
    ld      (hl), a
    inc     iy
    inc     iy
    djnz    0$
    
    ; XVs̐ݒ
    ld      a, TETRIMINO_POSITION_Y(ix)
    sub     #0x02
    ld      e, a
    ld      d, #0x00
    ld      hl, #_matrixPatternLine
    add     hl, de
    ld      a, #MATRIX_PATTERN_MATCH
    ld      b, #0x06
1$:
    ld      (hl), a
    inc     hl
    djnz    1$
    
    ; WX^̕A
    
    ; I
    ret

; eg~mXvCg\
;
TetriminoDrawSprite:
    
    ; WX^̕ۑ
    
    ; ʒu̎擾
    ld      a, TETRIMINO_POSITION_X(ix)
    add     a, a
    add     a, a
    add     a, a
    add     a, #0x40
    ld      c, a
    and     #0x08
    xor     #0x08
    srl     a
    ld      b, a
    ld      a, TETRIMINO_POSITION_Y(ix)
    sub     #0x07
    add     a, a
    add     a, a
    add     a, a
    sub     b
    ld      b, a
    
    ; XvCg̕`
    ld      d, TETRIMINO_TYPE(ix)
    xor     a
    srl     d
    rra
    srl     d
    rra
    ld      e, a
    ld      a, TETRIMINO_ROTATE(ix)
    rlca
    rlca
    rlca
    add     a, e
    ld      e, a
    ld      hl, #tetriminoSprite
    add     hl, de
    ld      e, TETRIMINO_PATTERN(ix)
    ld      d, TETRIMINO_COLOR(ix)
    ld      a, (hl)
    inc     hl
    add     a, b
    ld      0x00(iy), a
    inc     iy
    ld      a, (hl)
    inc     hl
    add     a, c
    ld      0x00(iy), a
    inc     iy
    ld      0x00(iy), e
    inc     iy
    ld      0x00(iy), d
    inc     iy
    ld      a, (hl)
    inc     hl
    add     a, b
    ld      0x00(iy), a
    inc     iy
    ld      a, (hl)
    inc     hl
    add     a, c
    ld      0x00(iy), a
    inc     iy
    ld      0x00(iy), e
    inc     iy
    ld      0x00(iy), d
    inc     iy
    ld      a, (hl)
    inc     hl
    add     a, b
    ld      0x00(iy), a
    inc     iy
    ld      a, (hl)
    inc     hl
    add     a, c
    ld      0x00(iy), a
    inc     iy
    ld      0x00(iy), e
    inc     iy
    ld      0x00(iy), d
    inc     iy
    ld      a, (hl)
    inc     hl
    add     a, b
    ld      0x00(iy), a
    inc     iy
    ld      a, (hl)
    inc     hl
    add     a, c
    ld      0x00(iy), a
    inc     iy
    ld      0x00(iy), e
    inc     iy
    ld      0x00(iy), d
    inc     iy
    
    ; WX^̕A
    
    ; I
    ret

; 萔̒`
;

; eg~m̏l
;
tetriminoDefault:

    ; NULL
    .db     TETRIMINO_TYPE_NULL
    .db     TETRIMINO_ROTATE_000
    .db     TETRIMINO_STATE_NULL
    .db     0x00
    .db     0x00, 0x00
    .db     0x00
    .db     0x00
    .db     TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1
    .db     TETRIMINO_FALL_INTERVAL
    .db     TETRIMINO_LOCK_INTERVAL
    .db     0x00, 0x00, 0x00
    
    ; 'O' TETRIMINO
    .db     TETRIMINO_TYPE_O
    .db     TETRIMINO_ROTATE_000
    .db     TETRIMINO_STATE_NULL
    .db     0x00
    .db     0x07, 0x06
    .db     0x0a
    .db     TETRIMINO_PATTERN_NORMAL
    .db     TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1
    .db     TETRIMINO_FALL_INTERVAL
    .db     TETRIMINO_LOCK_INTERVAL
    .db     0x00, 0x00, 0x00

    ; 'I' TETRIMINO
    .db     TETRIMINO_TYPE_I
    .db     TETRIMINO_ROTATE_000
    .db     TETRIMINO_STATE_NULL
    .db     0x00
    .db     0x07, 0x05
    .db     0x07
    .db     TETRIMINO_PATTERN_NORMAL
    .db     TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1
    .db     TETRIMINO_FALL_INTERVAL
    .db     TETRIMINO_LOCK_INTERVAL
    .db     0x00, 0x00, 0x00

    ; 'B' TETRIMINO
    .db     TETRIMINO_TYPE_B
    .db     TETRIMINO_ROTATE_000
    .db     TETRIMINO_STATE_NULL
    .db     0x00
    .db     0x07, 0x06
    .db     0x0d
    .db     TETRIMINO_PATTERN_NORMAL
    .db     TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1
    .db     TETRIMINO_FALL_INTERVAL
    .db     TETRIMINO_LOCK_INTERVAL
    .db     0x00, 0x00, 0x00

    ; 'D' TETRIMINO
    .db     TETRIMINO_TYPE_D
    .db     TETRIMINO_ROTATE_000
    .db     TETRIMINO_STATE_NULL
    .db     0x00
    .db     0x07, 0x06
    .db     0x0c
    .db     TETRIMINO_PATTERN_NORMAL
    .db     TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1
    .db     TETRIMINO_FALL_INTERVAL
    .db     TETRIMINO_LOCK_INTERVAL
    .db     0x00, 0x00, 0x00

    ; 'L' TETRIMINO
    .db     TETRIMINO_TYPE_L
    .db     TETRIMINO_ROTATE_000
    .db     TETRIMINO_STATE_NULL
    .db     0x00
    .db     0x07, 0x06
    .db     0x08
    .db     TETRIMINO_PATTERN_NORMAL
    .db     TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1
    .db     TETRIMINO_FALL_INTERVAL
    .db     TETRIMINO_LOCK_INTERVAL
    .db     0x00, 0x00, 0x00

    ; 'J' TETRIMINO
    .db     TETRIMINO_TYPE_J
    .db     TETRIMINO_ROTATE_000
    .db     TETRIMINO_STATE_NULL
    .db     0x00
    .db     0x07, 0x06
    .db     0x04
    .db     TETRIMINO_PATTERN_NORMAL
    .db     TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1
    .db     TETRIMINO_FALL_INTERVAL
    .db     TETRIMINO_LOCK_INTERVAL
    .db     0x00, 0x00, 0x00

    ; 'S' TETRIMINO
    .db     TETRIMINO_TYPE_S
    .db     TETRIMINO_ROTATE_000
    .db     TETRIMINO_STATE_NULL
    .db     0x00
    .db     0x07, 0x06
    .db     0x02
    .db     TETRIMINO_PATTERN_NORMAL
    .db     TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1
    .db     TETRIMINO_FALL_INTERVAL
    .db     TETRIMINO_LOCK_INTERVAL
    .db     0x00, 0x00, 0x00

    ; 'Z' TETRIMINO
    .db     TETRIMINO_TYPE_Z
    .db     TETRIMINO_ROTATE_000
    .db     TETRIMINO_STATE_NULL
    .db     0x00
    .db     0x07, 0x06
    .db     0x06
    .db     TETRIMINO_PATTERN_NORMAL
    .db     TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1
    .db     TETRIMINO_FALL_INTERVAL
    .db     TETRIMINO_LOCK_INTERVAL
    .db     0x00, 0x00, 0x00

    ; 'U' TETRIMINO
    .db     TETRIMINO_TYPE_U
    .db     TETRIMINO_ROTATE_000
    .db     TETRIMINO_STATE_NULL
    .db     0x00
    .db     0x07, 0x07
    .db     0x05
    .db     TETRIMINO_PATTERN_NORMAL
    .db     TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1
    .db     TETRIMINO_FALL_INTERVAL
    .db     TETRIMINO_LOCK_INTERVAL
    .db     0x00, 0x00, 0x00

    ; 'Y' TETRIMINO
    .db     TETRIMINO_TYPE_Y
    .db     TETRIMINO_ROTATE_000
    .db     TETRIMINO_STATE_NULL
    .db     0x00
    .db     0x07, 0x07
    .db     0x03
    .db     TETRIMINO_PATTERN_NORMAL
    .db     TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1, TETRIMINO_INPUT_INTERVAL_1
    .db     TETRIMINO_FALL_INTERVAL
    .db     TETRIMINO_LOCK_INTERVAL
    .db     0x00, 0x00, 0x00

; zu
;
tetriminoLocation:
    
    ; NULL
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000

    ; 'O' TETRIMINO
    .dw     0xffff, 0x0001, 0x0001, 0x000f, 0x0000, 0x000f, 0x0001, 0x0001
    .dw     0xffef, 0x0010, 0x0001, 0x0010, 0xffff, 0x0001, 0x000f, 0x0001
    .dw     0xffef, 0x0001, 0x000f, 0x0001, 0xfff0, 0x000f, 0x0001, 0x000f
    .dw     0xffef, 0x0001, 0x0001, 0x000f, 0xfff0, 0x000f, 0x0001, 0x0001
    .dw     0xfff0, 0x0001, 0x000f, 0x0001, 0xfff0, 0x0010, 0x0001, 0x0010
    .dw     0xfff1, 0x000f, 0x0001, 0x000f, 0x0000, 0x0001, 0x000f, 0x0001
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000

    ; 'I' TETRIMINO
    .dw     0xfff0, 0x0010, 0x0010, 0x0010, 0xfff0, 0x0010, 0x0010, 0x0010
    .dw     0xfff1, 0x000e, 0x0001, 0x000e, 0x0000, 0x0001, 0x000d, 0x0001
    .dw     0xffee, 0x0001, 0x0011, 0x0001, 0xffee, 0x0011, 0x0001, 0x0011
    .dw     0xffe0, 0x0010, 0x0010, 0x0010, 0xffe0, 0x0010, 0x0010, 0x0010
    .dw     0xfff1, 0x0001, 0x000d, 0x0001, 0xfff2, 0x000e, 0x0001, 0x000e
    .dw     0xffef, 0x0011, 0x0001, 0x0011, 0xffff, 0x0001, 0x0011, 0x0001
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000

    ; 'B' TETRIMINO
    .dw     0xfff0, 0x0010, 0x0001, 0x000f, 0xfff0, 0x0010, 0x0010, 0x0001
    .dw     0xfff1, 0x000e, 0x0001, 0x0010, 0x0000, 0x0001, 0x000e, 0x0001
    .dw     0xffef, 0x0010, 0x0001, 0x0001, 0xffff, 0x0001, 0x000f, 0x0002
    .dw     0xffef, 0x0001, 0x0010, 0x0010, 0xfff0, 0x000f, 0x0001, 0x0010
    .dw     0xfff0, 0x0001, 0x000e, 0x0001, 0xfff0, 0x0010, 0x0001, 0x000e
    .dw     0xffef, 0x0002, 0x000f, 0x0001, 0xffff, 0x0001, 0x0001, 0x0010
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000

    ; 'D' TETRIMINO
    .dw     0xfff0, 0x000f, 0x0001, 0x0010, 0xfff0, 0x0010, 0x000f, 0x0001
    .dw     0xffef, 0x0002, 0x000e, 0x0001, 0xffff, 0x0001, 0x0001, 0x000e
    .dw     0xffef, 0x0001, 0x0010, 0x0001, 0xfff0, 0x000f, 0x0001, 0x0011
    .dw     0xfff0, 0x0001, 0x000f, 0x0010, 0xfff0, 0x0010, 0x0001, 0x000f
    .dw     0xfff1, 0x000e, 0x0001, 0x0001, 0x0000, 0x0001, 0x000e, 0x0002
    .dw     0xffef, 0x0011, 0x0001, 0x000f, 0xffff, 0x0001, 0x0010, 0x0001
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000

    ; 'L' TETRIMINO
    .dw     0xffe0, 0x0010, 0x0010, 0x0001, 0xffe0, 0x0010, 0x0010, 0x0011
    .dw     0xfff1, 0x0001, 0x000e, 0x0010, 0xfff2, 0x000e, 0x0001, 0x000f
    .dw     0xffff, 0x0001, 0x0001, 0x0011, 0x0000, 0x000f, 0x0002, 0x0001
    .dw     0xffef, 0x0011, 0x0010, 0x0010, 0xffff, 0x0001, 0x0010, 0x0010
    .dw     0xfff0, 0x000f, 0x0001, 0x000e, 0xfff0, 0x0010, 0x000e, 0x0001
    .dw     0xffee, 0x0001, 0x0002, 0x000f, 0xffee, 0x0011, 0x0001, 0x0001
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000

    ; 'J' TETRIMINO
    .dw     0xffe0, 0x0010, 0x000f, 0x0001, 0xffe0, 0x0010, 0x0010, 0x000f
    .dw     0xffef, 0x0002, 0x0001, 0x000e, 0xfff2, 0x000d, 0x0001, 0x0001
    .dw     0xfff0, 0x0010, 0x0001, 0x0011, 0xfff0, 0x0010, 0x0011, 0x0001
    .dw     0xfff1, 0x000f, 0x0010, 0x0010, 0x0000, 0x0001, 0x000f, 0x0010
    .dw     0xffff, 0x0001, 0x0001, 0x000d, 0x0000, 0x000e, 0x0001, 0x0002
    .dw     0xffee, 0x0001, 0x0011, 0x0010, 0xffee, 0x0011, 0x0001, 0x0010
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000

    ; 'S' TETRIMINO
    .dw     0xfff0, 0x0010, 0x0001, 0x0010, 0xfff0, 0x0010, 0x0011, 0x0010
    .dw     0xfff1, 0x000f, 0x000f, 0x0001, 0x0000, 0x0001, 0x000f, 0x000f
    .dw     0xfffe, 0x0001, 0x0001, 0x0001, 0xfffe, 0x0002, 0x000f, 0x0002
    .dw     0xffdf, 0x0010, 0x0011, 0x0010, 0xffef, 0x0010, 0x0001, 0x0010
    .dw     0xffe1, 0x000f, 0x000f, 0x0001, 0xfff0, 0x0001, 0x000f, 0x000f
    .dw     0xffef, 0x0002, 0x000f, 0x0002, 0xffff, 0x0001, 0x0001, 0x0001
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000

    ; 'Z' TETRIMINO
    .dw     0xfff0, 0x000f, 0x0001, 0x000f, 0xfff0, 0x0010, 0x000f, 0x0010
    .dw     0xffef, 0x0002, 0x000d, 0x0002, 0xfffe, 0x0001, 0x0001, 0x0001
    .dw     0xffdf, 0x0011, 0x0010, 0x0001, 0xffef, 0x0001, 0x0010, 0x0011
    .dw     0xffe1, 0x0010, 0x000f, 0x0010, 0xfff1, 0x000f, 0x0001, 0x000f
    .dw     0xffff, 0x0001, 0x0001, 0x0001, 0x0000, 0x0002, 0x000d, 0x0002
    .dw     0xffef, 0x0011, 0x0010, 0x0001, 0xffff, 0x0001, 0x0010, 0x0011
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000

    ; 'U' TETRIMINO
    .dw     0xffef, 0x0010, 0x0002, 0x000f, 0xffff, 0x0010, 0x0001, 0x0001
    .dw     0xffef, 0x0001, 0x000f, 0x0011, 0xfff0, 0x000f, 0x0010, 0x0001
    .dw     0xffef, 0x0001, 0x0001, 0x000e, 0xfff0, 0x000f, 0x0002, 0x000e
    .dw     0xffef, 0x0001, 0x0001, 0x0010, 0xfff0, 0x000f, 0x0002, 0x0010
    .dw     0xfff0, 0x0001, 0x0010, 0x000f, 0xfff0, 0x0011, 0x000f, 0x0001
    .dw     0xfff1, 0x000e, 0x0002, 0x000f, 0x0001, 0x000e, 0x0001, 0x0001
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000

    ; 'Y' TETRIMINO
    .dw     0xfff0, 0x000f, 0x0001, 0x0001, 0xfff0, 0x0010, 0x000f, 0x0002
    .dw     0xffef, 0x0002, 0x000f, 0x0010, 0xffff, 0x0001, 0x0001, 0x000f
    .dw     0xfff0, 0x000f, 0x0001, 0x0001, 0xfff0, 0x0010, 0x000f, 0x0002
    .dw     0xffef, 0x0002, 0x000f, 0x0010, 0xffff, 0x0001, 0x0001, 0x000f
    .dw     0xfff0, 0x000f, 0x0001, 0x0001, 0xfff0, 0x0010, 0x000f, 0x0002
    .dw     0xffef, 0x0002, 0x000f, 0x0010, 0xffff, 0x0001, 0x0001, 0x000f
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
    .dw     0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000

; XvCg
;
tetriminoSprite:
    
    ; NULL
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    
    ; 'O' TETRIMINO
    .db     0xff, 0x00, 0x03, 0xf8, 0x03, 0x08, 0x07, 0x00
    .db     0xff, 0x00, 0xfb, 0xf8, 0x07, 0x00, 0x03, 0xf8
    .db     0xff, 0x00, 0xf7, 0x00, 0x03, 0xf8, 0xfb, 0xf8
    .db     0xff, 0x00, 0xfb, 0x08, 0xfb, 0xf8, 0xf7, 0x00
    .db     0xff, 0x00, 0x03, 0x08, 0xf7, 0x00, 0xfb, 0x08
    .db     0xff, 0x00, 0x07, 0x00, 0xfb, 0x08, 0x03, 0x08
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

    ; 'I' TETRIMINO
    .db     0xff, 0x00, 0xf7, 0x00, 0x07, 0x00, 0x0f, 0x00
    .db     0xff, 0x00, 0xfb, 0x08, 0x03, 0xf8, 0x07, 0xf0
    .db     0xff, 0x00, 0x03, 0x08, 0xfb, 0xf8, 0xf7, 0xf0
    .db     0xff, 0x00, 0x07, 0x00, 0xf7, 0x00, 0xef, 0x00
    .db     0xff, 0x00, 0x03, 0xf7, 0xfb, 0x08, 0xf7, 0x10
    .db     0xff, 0x00, 0xfb, 0xf7, 0x03, 0x08, 0x07, 0x10
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

    ; 'B' TETRIMINO
    .db     0xff, 0x00, 0xf7, 0x00, 0x07, 0x00, 0x03, 0x08
    .db     0xff, 0x00, 0xfb, 0x08, 0x03, 0xf8, 0x07, 0x00
    .db     0xff, 0x00, 0x03, 0x08, 0xfb, 0xf8, 0x03, 0xf8
    .db     0xff, 0x00, 0x07, 0x00, 0xf7, 0x00, 0xfb, 0xf8
    .db     0xff, 0x00, 0x03, 0xf8, 0xfb, 0x08, 0xf7, 0x00
    .db     0xff, 0x00, 0xfb, 0xf8, 0x03, 0x08, 0xfb, 0x08
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

    ; 'D' TETRIMINO
    .db     0xff, 0x00, 0xf7, 0x00, 0x07, 0x00, 0x03, 0xf8
    .db     0xff, 0x00, 0xfb, 0x08, 0x03, 0xf8, 0xfb, 0xf8
    .db     0xff, 0x00, 0x03, 0x08, 0xfb, 0xf8, 0xf7, 0x00
    .db     0xff, 0x00, 0x07, 0x00, 0xf7, 0x00, 0xfb, 0x08
    .db     0xff, 0x00, 0x03, 0xf8, 0xfb, 0x08, 0x03, 0x08
    .db     0xff, 0x00, 0xfb, 0xf8, 0x03, 0x08, 0x07, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

    ; 'L' TETRIMINO
    .db     0xff, 0x00, 0xf7, 0x00, 0xef, 0x00, 0x03, 0x08
    .db     0xff, 0x00, 0xfb, 0x08, 0xf7, 0x10, 0x07, 0x00
    .db     0xff, 0x00, 0x03, 0x08, 0x07, 0x10, 0x03, 0xf8
    .db     0xff, 0x00, 0x07, 0x00, 0x0f, 0x00, 0xfb, 0xf8
    .db     0xff, 0x00, 0x03, 0xf8, 0x07, 0xf0, 0xf7, 0x00
    .db     0xff, 0x00, 0xfb, 0xf8, 0xf7, 0xf0, 0xfb, 0x08
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

    ; 'J' TETRIMINO
    .db     0xff, 0x00, 0xf7, 0x00, 0xef, 0x00, 0x03, 0xf8
    .db     0xff, 0x00, 0xfb, 0x08, 0xf7, 0x10, 0xfb, 0xf8
    .db     0xff, 0x00, 0x03, 0x08, 0x07, 0x10, 0xf7, 0x00
    .db     0xff, 0x00, 0x07, 0x00, 0x0f, 0x00, 0xfb, 0x08
    .db     0xff, 0x00, 0x03, 0xf8, 0x07, 0xf0, 0x03, 0x08
    .db     0xff, 0x00, 0xfb, 0xf8, 0xf7, 0xf0, 0x07, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

    ; 'S' TETRIMINO
    .db     0xff, 0x00, 0xf7, 0x00, 0x03, 0x08, 0x0b, 0x08
    .db     0xff, 0x00, 0xfb, 0x08, 0x07, 0x00, 0x0b, 0xf8
    .db     0xff, 0x00, 0x03, 0x08, 0x03, 0xf8, 0xff, 0xf0
    .db     0xff, 0x00, 0x07, 0x00, 0xfb, 0xf8, 0xf3, 0xf8
    .db     0xff, 0x00, 0x03, 0xf8, 0xf7, 0x00, 0xf3, 0x08
    .db     0xff, 0x00, 0xfb, 0xf8, 0xfb, 0x08, 0xff, 0x10
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

    ; 'Z' TETRIMINO
    .db     0xff, 0x00, 0xf7, 0x00, 0x03, 0xf8, 0x0b, 0xf8
    .db     0xff, 0x00, 0xfb, 0x08, 0xfb, 0xf8, 0xff, 0xf0
    .db     0xff, 0x00, 0x03, 0x08, 0xf7, 0x00, 0xf3, 0xf8
    .db     0xff, 0x00, 0x07, 0x00, 0xfb, 0x08, 0xf3, 0x08
    .db     0xff, 0x00, 0x03, 0xf8, 0x03, 0x08, 0xff, 0x10
    .db     0xff, 0x00, 0xfb, 0xf8, 0x07, 0x00, 0x0b, 0x08
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

    ; 'U' TETRIMINO
    .db     0xfb, 0xf8, 0x03, 0xf8, 0x07, 0x00, 0x03, 0x08
    .db     0xf7, 0x00, 0xfb, 0xf8, 0x03, 0xf8, 0x07, 0x00
    .db     0xfb, 0x08, 0xf7, 0x00, 0xfb, 0xf8, 0x03, 0xf8
    .db     0x03, 0x08, 0xfb, 0x08, 0xf7, 0x00, 0xfb, 0xf8
    .db     0x07, 0x00, 0x03, 0x08, 0xfb, 0x08, 0xf7, 0x00
    .db     0x03, 0xf8, 0x07, 0x00, 0x03, 0x08, 0xfb, 0x08
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

    ; 'Y' TETRIMINO
    .db     0xff, 0x00, 0xf7, 0x00, 0x03, 0xf8, 0x03, 0x08
    .db     0xff, 0x00, 0xfb, 0x08, 0xfb, 0xf8, 0x07, 0x00
    .db     0xff, 0x00, 0x03, 0x08, 0xf7, 0x00, 0x03, 0xf8
    .db     0xff, 0x00, 0x07, 0x00, 0xfb, 0x08, 0xfb, 0xf8
    .db     0xff, 0x00, 0x03, 0xf8, 0x03, 0x08, 0xf7, 0x00
    .db     0xff, 0x00, 0xfb, 0xf8, 0x07, 0x00, 0xfb, 0x08
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

; 
;
tetriminoDetectPoint:
    
    .db     0x00, 0x00, 0x00, 0xff, 0x01, 0xff, 0x01, 0x00, 0xff, 0x00, 0xff, 0xff, 0x02, 0x00, 0xfe, 0x00
    .db     0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x01, 0x01, 0xff, 0x01, 0xff, 0x00, 0x02, 0x00, 0xfe, 0x00

; ]̔
tetriminoDetectRotate:

    ; |FO
    .db     TETRIMINO_DETECT_O
    .db     TETRIMINO_DETECT_000
    .db     TETRIMINO_DETECT_240
    .db     TETRIMINO_DETECT_300
    .db     TETRIMINO_DETECT_120
    .db     TETRIMINO_DETECT_060
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    
    ; |FP
    .db     TETRIMINO_DETECT_O
    .db     TETRIMINO_DETECT_000
    .db     TETRIMINO_DETECT_300
    .db     TETRIMINO_DETECT_240
    .db     TETRIMINO_DETECT_060
    .db     TETRIMINO_DETECT_120
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    
    ; FO
    .db     TETRIMINO_DETECT_240
    .db     TETRIMINO_DETECT_300
    .db     TETRIMINO_DETECT_O
    .db     TETRIMINO_DETECT_000
    .db     TETRIMINO_DETECT_120
    .db     TETRIMINO_DETECT_060
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    
    ; FP
    .db     TETRIMINO_DETECT_300
    .db     TETRIMINO_DETECT_240
    .db     TETRIMINO_DETECT_O
    .db     TETRIMINO_DETECT_000
    .db     TETRIMINO_DETECT_060
    .db     TETRIMINO_DETECT_120
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    
    ; FO
    .db     TETRIMINO_DETECT_120
    .db     TETRIMINO_DETECT_060
    .db     TETRIMINO_DETECT_O
    .db     TETRIMINO_DETECT_000
    .db     TETRIMINO_DETECT_240
    .db     TETRIMINO_DETECT_300
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    
    ; FP
    .db     TETRIMINO_DETECT_060
    .db     TETRIMINO_DETECT_120
    .db     TETRIMINO_DETECT_O
    .db     TETRIMINO_DETECT_000
    .db     TETRIMINO_DETECT_300
    .db     TETRIMINO_DETECT_240
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL

; ړ̔
tetriminoDetectMove:

    ; |FO
    .db     TETRIMINO_DETECT_O
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    
    ; |FP
    .db     TETRIMINO_DETECT_O
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    
    ; FO
    .db     TETRIMINO_DETECT_240
    .db     TETRIMINO_DETECT_300
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    
    ; FP
    .db     TETRIMINO_DETECT_300
    .db     TETRIMINO_DETECT_240
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    
    ; FO
    .db     TETRIMINO_DETECT_120
    .db     TETRIMINO_DETECT_060
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    
    ; FP
    .db     TETRIMINO_DETECT_060
    .db     TETRIMINO_DETECT_120
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL
    .db     TETRIMINO_DETECT_NULL

; ̃eg~m
;
tetriminoNextColor:

    ; NULL
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    
    ; 'O' TETRIMINO
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a
    .db     0xa0, 0xa0, 0xa0, 0xa0, 0xaa, 0xaa, 0xaa, 0xaa
    .db     0xa0, 0xa0, 0xa0, 0xa0, 0xaa, 0xaa, 0xaa, 0xaa
    .db     0x00, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a
    .db     0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00
    .db     0xaa, 0xaa, 0xaa, 0xaa, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0xaa, 0xaa, 0xaa, 0xaa, 0xa0, 0xa0, 0xa0, 0xa0
    .db     0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    
    ; 'I' TETRIMINO
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70
    .db     0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70
    .db     0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70
    .db     0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70
    .db     0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70, 0x70
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

    ; 'B' TETRIMINO
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xD0
    .db     0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xD0
    .db     0xd0, 0xd0, 0xd0, 0xd0, 0xdd, 0xdd, 0xdd, 0xdd
    .db     0x00, 0x00, 0x00, 0x00, 0x0d, 0x0d, 0x0d, 0x0d
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xD0
    .db     0xdd, 0xdd, 0xdd, 0xdd, 0xd0, 0xd0, 0xd0, 0xd0
    .db     0x0d, 0x0d, 0x0d, 0x0d, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    
    ; 'D' TETRIMINO
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0
    .db     0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x0c, 0x0c
    .db     0xc0, 0xc0, 0xc0, 0xc0, 0xcc, 0xcc, 0xcc, 0xcc
    .db     0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x0c, 0x0c, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00
    .db     0xcc, 0xcc, 0xcc, 0xcc, 0xc0, 0xc0, 0xc0, 0xc0
    .db     0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    
    ; 'L' TETRIMINO
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
    .db     0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
    .db     0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80
    .db     0x80, 0x80, 0x80, 0x80, 0x88, 0x88, 0x88, 0x88
    .db     0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00
    .db     0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00
    
    ; 'J' TETRIMINO
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
    .db     0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
    .db     0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04
    .db     0x40, 0x40, 0x40, 0x40, 0x44, 0x44, 0x44, 0x44
    .db     0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00
    .db     0x04, 0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    
    ; 'S' TETRIMINO
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
    .db     0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20
    .db     0x20, 0x20, 0x20, 0x20, 0x22, 0x22, 0x22, 0x22
    .db     0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x02, 0x02
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02
    .db     0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00
    .db     0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00
    
    ; 'Z' TETRIMINO
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60
    .db     0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06
    .db     0x60, 0x60, 0x60, 0x60, 0x66, 0x66, 0x66, 0x66
    .db     0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06
    .db     0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00
    .db     0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    
    ; 'U' TETRIMINO
    .db     0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x05
    .db     0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x05
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05
    .db     0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05
    .db     0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x05
    .db     0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x05, 0x05
    .db     0x05, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00
    .db     0x55, 0x55, 0x55, 0x55, 0x50, 0x50, 0x50, 0x50
    .db     0x55, 0x55, 0x55, 0x55, 0x50, 0x50, 0x50, 0x50
    .db     0x05, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    
    ; 'Y' TETRIMINO 0x03
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30
    .db     0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03
    .db     0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x33, 0x33
    .db     0x30, 0x30, 0x30, 0x30, 0x33, 0x33, 0x33, 0x33
    .db     0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03
    .db     0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00
    .db     0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00
    .db     0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00
    .db     0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    .db     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

; 
;
tetriminoFallInterval:
    
    .db     60, 60, 48, 37, 28, 21, 16, 12
    .db      8,  6,  4,  3,  2,  1,  1,  1
    
tetriminoFallLine:

    .db      1,  1,  1,  1,  1,  1,  1,  1
    .db      1,  1,  1,  1,  1,  1,  2,  3

; DATA ̈
;
    .area   _DATA

; ϐ̒`
;

; eg~m
;
_tetrimino::

    .ds     TETRIMINO_SIZE

_tetriminoGhost::

    .ds     TETRIMINO_SIZE

tetriminoLast:

    .ds     TETRIMINO_SIZE

; L[
;
tetriminoQueue:

    .ds     (TETRIMINO_TYPE_SIZE - 1) * 2 + 1
    
